# Measurement - Earned Value Hours
# Copyright 2004, 2007 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 040907 - started description of actions
# 040914 - reworked description of actions; first draft of code
# 041009 - minor changes
# 041121 - fixed some errors
# 041122 - don't put future totals for actual and earned value
# 041202 - adjust cut off date for "future"
# 041218 - fix last weekly date to use today
# 070411 - fix error identified by "trezzini" in the forum

# known problems
#   doesn't clear out prior totals, this could be done during creation of the index

# This routine is given:
#   - a list of project ids
#   - a list of weeks
#   - a list of project/measurement records to update

# It uses the following fields:
#   Calculates the following: 
#   - ProjectWeek
#       ActualEffortHours (sums all of the effort for each time period)
#       EarnedValueHours (sums all effort of all tasks completed during period)
#       PlannedValueHours (sums all effort of all tasks scheduled for completion during period)
#       ActualEffortHoursToDate
#       EarnedValueHoursToDate
#       PlannedValueHoursToDate
#   - ProjectMeasurement
#       LastWeekly

# It uses the following:
#   - Project
#       EffortAdjustment
#   - ProjectWeek
#       ActualEffortHoursToDate
#       EarnedValueHoursToDate
#       PlannedValueHoursToDate
#       ActualEffortHours (looks here first)
#   - ProjectResourceWeek
#       ActualEffortHours (looks here second)
#   - ProjectResourceDay
#       ActualEffortHours (looks here third)
#   - Task
#       EffortHours
#       ActualEndDate
#       BaseEndDate  (looks here first)
#       CalculatedEndDate  (looks here second)

def CalculateMeasurements(projects, periods, records):
    """ 
    make sure period are all valid dates (here or before this is called?)
    weeks must be in ascending order
    """
    # make sure all required tables exist
    if not (Data.Database.has_key('ProjectWeek') 
        and Data.Database.has_key('ProjectResourceWeek')
        and Data.Database.has_key('ProjectResourceDay')
        and Data.Database.has_key('ProjectMeasurement')
        ):
        pass   # give error message

    pw = Data.Database['ProjectWeek']
    pr = Data.Database['ProjectResource']
    prw = Data.Database['ProjectResourceWeek']
    prd = Data.Database['ProjectResourceDay']
    task = Data.Database['Task']
    pm = Data.Database['ProjectMeasurement']

    # create index for project/week (used to look up "To Date" totals)
    minweek = min(periods)
    priorweek = Data.DateIndex[Data.DateConv[minweek] - 7]
    weekindex = {}
    for k, v in pw.iteritems():
        p = v.get('ProjectID')  # these should always be there, but just in case we'll default to None
        w = v.get('Period')
        if (p in projects) and ((w in periods) or (w == priorweek)):
            weekindex[(p, w)] = k

    # create summary of project/resource/week
    prwEffort = {}
    for k, v in prw.iteritems():
        if debug: print "prwEffort", k, v
        if v.get('zzStatus') == 'deleted': continue
        prid = v.get('ProjectResourceID')
        if not prid or not pr.has_key(prid): continue
        p = pr[prid].get('ProjectID')
        w = v.get('Period')
        if debug: print "p, w", p, w
        if (p in projects) and (w in periods):
            hours = v.get('ActualEffortHours')
            if debug: print "hours", hours
            if hours:
                if prwEffort.has_key((p,w)):
                    prwEffort[(p,w)] += hours
                else:
                    prwEffort[(p,w)] = hours

    # create summary of project/resource/day
    prdEffort = {}
    for k, v in prd.iteritems():
        if v.get('zzStatus') == 'deleted': continue
        prid = v.get('ProjectResourceID')
        if not prid or not pr.has_key(prid): continue
        p = pr[prid].get('ProjectID')
        d = v.get('Period')
        if not d or not Data.DateConv.has_key(d): continue
        di = Data.DateConv[d]
        w = Data.DateIndex[di - Data.DateInfo[di][2]]  # convert to beginning of week (date index) minus (day of week)
        if (p in projects) and (w in periods):
            hours = v.get('ActualEffortHours')
            if hours:
                if prdEffort.has_key((p,w)):
                    prdEffort[(p,w)] += hours
                else:
                    prdEffort[(p,w)] = hours

    pwEV = {}
    pwPV = {}
    for k, v in task.iteritems():  # calculate earned value and planned value by week
        if v.get('zzStatus') == 'deleted': continue
        p = v.get('ProjectID')
        if not (p in projects): continue

        plandate = v.get('BaseEndDate') or v.get('CalculatedEndDate')
        if debug: print "plandate", plandate
        if Data.DateConv.has_key(plandate): # ignore invalid dates
            di = Data.DateConv[plandate]
            w = Data.DateIndex[di - Data.DateInfo[di][2]]  # convert to week (date index) minus (day of week)
            if w in periods:
                if debug: print "w", w
                hours = v.get('EffortHours')
                if hours:
                    if pwPV.has_key((p,w)):
                        pwPV[(p,w)] += hours
                else:
                        pwPV[(p,w)] = hours

        actualdate = v.get('ActualEndDate')
        if debug: print "actualdate", actualdate
        if Data.DateConv.has_key(actualdate): # ignore invalid dates
            di = Data.DateConv[actualdate]
            w = Data.DateIndex[di - Data.DateInfo[di][2]]  # convert to week (date index) minus (day of week)
            if w in periods:
                if debug: print "w", w
                hours = v.get('EffortHours')
                                             # apply project adjustment
                if hours:
                    if pwEV.has_key((p,w)):
                        pwEV[(p,w)] += hours
                else:
                        pwEV[(p,w)] = hours

    today = Data.GetToday()
    di = Data.DateConv[today]
    cutoff = Data.DateIndex[di - Data.DateInfo[di][2]]  # convert to week (date index) minus (day 

    for p in projects:
        for w in periods:
            change = { 'Table': 'ProjectWeek', 'ProjectID': p, 'Period': w }
            # ActualEffortHours (sums all of the effort for each time period)
            aeh = None
            pwid = weekindex.get((p, w))
            if pwid:
                change['ID'] = pwid
            #    aeh = pw[pwid].get('ActualEffortHours')  # look for project/week total first

            #if aeh == None:  # total may be zero
                aeh = prwEffort.get((p,w)) # look in project/resource/week
                if aeh == None:
                    aeh = prdEffort.get((p,w)) # look in project/resource/day
                if aeh != None:
                    change['ActualEffortHours'] = aeh  # update if summary found

            if not aeh: aeh = 0

            ev = pwEV.get((p,w))
            if not ev: ev = 0
            change['EarnedValueHours'] = ev

            pv = pwPV.get((p,w))
            if not pv: pv = 0 
            change['PlannedValueHours'] = pv

            # get prior week cumulative totals
            priorweek = Data.DateIndex[Data.DateConv[w] - 7] # find prior week
            pwidprior = weekindex.get((p, priorweek))

            if pwidprior:
                priorweekEVToDate = pw[pwidprior].get('EarnedValueHoursToDate')
                priorweekPVToDate = pw[pwidprior].get('PlannedValueHoursToDate')
                priorweekAEToDate = pw[pwidprior].get('ActualEffortHoursToDate')

                if not priorweekEVToDate: priorweekEVToDate = 0
                if not priorweekPVToDate: priorweekPVToDate = 0
                if not priorweekAEToDate: priorweekAEToDate = 0
            else:
                priorweekEVToDate, priorweekPVToDate, priorweekAEToDate = 0, 0, 0

            change['ActualEffortHoursToDate'] = priorweekAEToDate + aeh
            change['EarnedValueHoursToDate'] = priorweekEVToDate + ev
            change['PlannedValueHoursToDate'] = priorweekPVToDate + pv

            if w >= cutoff:
                change['ActualEffortHours'] = None
                change['EarnedValueHours'] = None
                change['ActualEffortHoursToDate'] = None
                change['EarnedValueHoursToDate'] = None

            # ?add project/week to index? Yes, needed to get prior week totals.

            undo = Data.Update(change)
            if not pwid:
                weekindex[(p, w)] = undo['ID']

    rundate = Data.GetToday()
    change = { 'Table': 'ProjectMeasurement' }
    for rec in records:
        change['ID'] = rec
        change['LastUpdate'] = rundate
        Data.Update(change)

    if debug: print "weekindex", weekindex
    if debug: print "prwEffort", prwEffort
    if debug: print "prdEffort", prdEffort
    if debug: print "pwEV", pwEV
    if debug: print "pwPV", pwPV

    # Data.SetUndo  -- set undo is done by the calling program

CalculateMeasurements(projects, periods, records)
